/*
 * Decompiled with CFR 0.152.
 */
package jade.core.replication;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BackEndContainer;
import jade.core.BaseService;
import jade.core.Command;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.UnreachableException;
import jade.core.VerticalCommand;
import jade.core.replication.BEReplicationSlice;
import jade.security.JADESecurityException;
import jade.util.leap.LinkedList;
import jade.util.leap.List;

public class BEReplicationService
extends BaseService {
    private static final String[] OWNED_COMMANDS = new String[]{"Become-Master", "Is-Master", "Start-Monitor", "Stop-Monitor"};
    private BackEndContainer myContainer;
    private Profile myProfile;
    private ServiceComponent localSlice;
    private Filter outFilter;
    private Filter inFilter;
    private Sink sourceSink;
    private ReplicaInfo[] myReplicas = new ReplicaInfo[0];
    private ReplicaMonitor myMonitor;
    private List includeAll;
    private List excludeMyself;
    private String myMediatorID;
    private int myReplicaIndex;
    private int myMonitoredReplicaIndex;
    private String masterSliceName;
    private boolean booting = true;
    private int expectedReplicas;
    private String[] myReplicaNames;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = (BackEndContainer)ac;
        this.myProfile = p;
        this.myMediatorID = p.getParameter("be-mediator-id", null);
        this.myReplicaIndex = Integer.parseInt(p.getParameter("be-replica-index", "0"));
        this.localSlice = new ServiceComponent(p);
        this.sourceSink = new CommandSourceSink();
        this.outFilter = new OutgoingCommandFilter();
        this.inFilter = new IncomingCommandFilter();
    }

    public String getName() {
        return "jade.core.replication.BEReplication";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.replication.BEReplicationSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.outFilter;
        }
        return this.inFilter;
    }

    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.sourceSink;
        }
        return null;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void boot(Profile p) throws ServiceException {
        block5: {
            try {
                this.includeAll = new LinkedList();
                this.excludeMyself = new LinkedList();
                this.excludeMyself.add(this.getLocalNode().getName());
                this.myMonitoredReplicaIndex = -1;
                this.masterSliceName = p.getParameter("master-node-name", null);
                if (this.masterSliceName == null) {
                    this.expectedReplicas = Integer.parseInt(p.getParameter("be-replicas-size", "0"));
                    this.myReplicaNames = new String[this.expectedReplicas + 1];
                    this.myReplicaNames[0] = this.masterSliceName = this.getLocalNode().getName();
                    break block5;
                }
                String localNodeName = this.getLocalNode().getName();
                BEReplicationSlice masterSlice = (BEReplicationSlice)this.getSlice(this.masterSliceName);
                try {
                    masterSlice.acceptReplica(localNodeName, Integer.toString(this.myReplicaIndex));
                }
                catch (IMTPException imtpe) {
                    masterSlice = (BEReplicationSlice)this.getFreshSlice(this.masterSliceName);
                    masterSlice.acceptReplica(localNodeName, Integer.toString(this.myReplicaIndex));
                }
                this.booting = false;
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("An error occurred during service startup.", imtpe);
            }
        }
    }

    private boolean[] getReplicasReachability() {
        boolean[] result = new boolean[this.myReplicas.length];
        int i = 0;
        while (i < this.myReplicas.length) {
            result[i] = this.myReplicas[i].isReachable();
            ++i;
        }
        return result;
    }

    private void broadcastToReplicas(HorizontalCommand cmd, List excludeList) throws IMTPException, ServiceException {
        String localNodeName = this.getLocalNode().getName();
        int i = 0;
        while (i < this.myReplicas.length) {
            BEReplicationSlice slice = this.myReplicas[i].getSlice();
            boolean reachable = this.myReplicas[i].isReachable();
            String sliceName = slice.getNode().getName();
            if (reachable && excludeList.indexOf(sliceName) == -1) {
                slice.serve(cmd);
                Object ret = cmd.getReturnValue();
                if (ret != null && ret instanceof Throwable) {
                    Throwable t = (Throwable)ret;
                    System.out.println("### Exception in broadcasting to slice " + sliceName + ": " + t.getMessage() + " ###");
                }
            }
            ++i;
        }
    }

    private void startMonitor(long delay) {
        this.stopMonitor();
        this.myMonitor = new ReplicaMonitor(delay);
        this.myMonitor.start();
    }

    private void stopMonitor() {
        if (this.myMonitor != null) {
            this.myMonitor.stop();
            this.myMonitor = null;
        }
    }

    static /* synthetic */ ReplicaInfo[] access$1002(BEReplicationService x0, ReplicaInfo[] x1) {
        x0.myReplicas = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1302(BEReplicationService x0, String[] x1) {
        x0.myReplicaNames = x1;
        return x1;
    }

    private class ReplicaMonitor
    implements Runnable {
        private long delayTime;
        private boolean active = true;
        private Thread myThread;

        public ReplicaMonitor(long millis) {
            this.delayTime = millis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.active) {
                Object info;
                int i = 0;
                while (i < BEReplicationService.this.myReplicas.length) {
                    info = BEReplicationService.this.myReplicas[i];
                    if (!((ReplicaInfo)info).isReachable()) {
                        try {
                            System.out.println("### Restarting replica <" + ((ReplicaInfo)info).getName() + "> ###");
                            BEReplicationService.this.myContainer.restartReplica(i);
                        }
                        catch (IMTPException imtpe) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                try {
                    info = this;
                    synchronized (info) {
                        this.wait(this.delayTime);
                    }
                }
                catch (InterruptedException ie) {
                    this.active = false;
                }
            }
        }

        public void start() {
            this.myThread = new Thread(this);
            this.myThread.start();
        }

        public synchronized void stop() {
            this.active = false;
            this.notifyAll();
        }
    }

    private class ReplicaInfo {
        private String name;
        private boolean reachable;
        private BEReplicationSlice slice;

        public ReplicaInfo(String n, BEReplicationSlice s) {
            this.name = n;
            this.slice = s;
            this.reachable = true;
        }

        public String getName() {
            return this.name;
        }

        public void setReachable(boolean b) {
            block2: {
                this.reachable = b;
                if (!this.reachable) break block2;
                try {
                    this.slice = (BEReplicationSlice)BEReplicationService.this.getFreshSlice(this.name);
                }
                catch (ServiceException se) {
                    this.reachable = false;
                }
            }
        }

        public boolean isReachable() {
            return this.reachable;
        }

        public void setSlice(BEReplicationSlice s) {
            this.slice = s;
        }

        public BEReplicationSlice getSlice() {
            return this.slice;
        }
    }

    private class ServiceComponent
    implements Service.Slice,
    NodeEventListener {
        private NodeFailureMonitor nodeMonitor;

        public ServiceComponent(Profile p) {
        }

        private void attachTo(BEReplicationSlice slice) throws IMTPException, ServiceException {
            if (this.nodeMonitor != null) {
                this.nodeMonitor.stop();
            }
            if (BEReplicationService.this.getLocalNode().getName().equals(slice.getNode().getName())) {
                return;
            }
            this.nodeMonitor = NodeFailureMonitor.getFailureMonitor();
            this.nodeMonitor.start(slice.getNode(), this);
        }

        private void updateMonitoredSlice() throws IMTPException, ServiceException {
            int monitoredIndex = this.mod(BEReplicationService.this.myReplicaIndex - 1, BEReplicationService.this.myReplicas.length);
            int i = 0;
            while (i < BEReplicationService.this.myReplicas.length - 1) {
                ReplicaInfo info = BEReplicationService.this.myReplicas[monitoredIndex];
                if (info.isReachable()) {
                    if (BEReplicationService.this.myMonitoredReplicaIndex != monitoredIndex) {
                        BEReplicationService.this.myMonitoredReplicaIndex = monitoredIndex;
                        this.attachTo(info.getSlice());
                    }
                    return;
                }
                monitoredIndex = this.mod(monitoredIndex - 1, BEReplicationService.this.myReplicas.length);
                ++i;
            }
            BEReplicationService.this.myMonitoredReplicaIndex = -1;
            if (this.nodeMonitor != null) {
                this.nodeMonitor.stop();
            }
        }

        public int mod(int num, int radix) {
            while (num < 0) {
                num += radix;
            }
            return num % radix;
        }

        public Service getService() {
            return BEReplicationService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return BEReplicationService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            Command result;
            block17: {
                result = null;
                try {
                    String cmdName = cmd.getName();
                    Object[] params = cmd.getParams();
                    if (cmdName.equals("1")) {
                        String sliceName = (String)params[0];
                        String replicaIndex = (String)params[1];
                        this.acceptReplica(sliceName, replicaIndex);
                    } else if (cmdName.equals("2")) {
                        String name = (String)params[0];
                        this.setMaster(name);
                    } else if (cmdName.equals("3")) {
                        String[] replicas = (String[])params[0];
                        boolean[] status = (boolean[])params[1];
                        this.setReplicas(replicas, status);
                    } else if (cmdName.equals("4")) {
                        int index = (Integer)params[0];
                        this.replicaUp(index);
                    } else if (cmdName.equals("5")) {
                        int index = (Integer)params[0];
                        this.replicaDown(index);
                    } else if (cmdName.equals("6")) {
                        this.exitReplica();
                    } else if (cmdName.equals("7")) {
                        AID name = (AID)params[0];
                        this.bornAgent(name);
                    } else if (cmdName.equals("8")) {
                        AID name = (AID)params[0];
                        this.deadAgent(name);
                    }
                }
                catch (Throwable t) {
                    cmd.setReturnValue(t);
                    if (result == null) break block17;
                    result.setReturnValue(t);
                }
            }
            return result;
        }

        private synchronized void acceptReplica(String sliceName, String replicaIndex) throws IMTPException, ServiceException {
            block8: {
                if (BEReplicationService.this.booting) {
                    try {
                        int idx = Integer.parseInt(replicaIndex);
                        ((BEReplicationService)BEReplicationService.this).myReplicaNames[idx] = sliceName;
                        BEReplicationService.this.expectedReplicas--;
                        if (BEReplicationService.this.expectedReplicas != 0) break block8;
                        BEReplicationService.this.booting = false;
                        boolean[] allTrue = new boolean[BEReplicationService.this.myReplicaNames.length];
                        int i = 0;
                        while (i < allTrue.length) {
                            allTrue[i] = true;
                            ++i;
                        }
                        this.setReplicas(BEReplicationService.this.myReplicaNames, allTrue);
                        boolean[] status = BEReplicationService.this.getReplicasReachability();
                        int i2 = 1;
                        while (i2 < BEReplicationService.this.myReplicaNames.length) {
                            BEReplicationSlice slice = (BEReplicationSlice)BEReplicationService.this.getSlice(BEReplicationService.this.myReplicaNames[i2]);
                            try {
                                slice.setReplicas(BEReplicationService.this.myReplicaNames, status);
                            }
                            catch (IMTPException imtpe) {
                                slice = (BEReplicationSlice)BEReplicationService.this.getFreshSlice(BEReplicationService.this.myReplicaNames[i2]);
                                slice.setReplicas(BEReplicationService.this.myReplicaNames, status);
                            }
                            ++i2;
                        }
                        BEReplicationService.this.myContainer;
                        BEReplicationService.this.startMonitor(BackEndContainer.REPLICA_CHECK_DELAY);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else {
                    BEReplicationSlice slice = (BEReplicationSlice)BEReplicationService.this.getFreshSlice(sliceName);
                    slice.setReplicas(BEReplicationService.this.myReplicaNames, BEReplicationService.this.getReplicasReachability());
                    GenericCommand hCmd = new GenericCommand("4", "jade.core.replication.BEReplication", null);
                    hCmd.addParam(new Integer(replicaIndex));
                    LinkedList l = new LinkedList();
                    l.add(sliceName);
                    BEReplicationService.this.broadcastToReplicas(hCmd, l);
                }
            }
        }

        private void setMaster(String name) throws IMTPException {
            BEReplicationService.this.masterSliceName = name;
        }

        private void setReplicas(String[] replicas, boolean[] status) throws IMTPException, ServiceException {
            BEReplicationService.access$1002(BEReplicationService.this, new ReplicaInfo[replicas.length]);
            int i = 0;
            while (i < replicas.length) {
                try {
                    BEReplicationSlice s = (BEReplicationSlice)BEReplicationService.this.getSlice(replicas[i]);
                    ((BEReplicationService)BEReplicationService.this).myReplicas[i] = new ReplicaInfo(replicas[i], s);
                    BEReplicationService.this.myReplicas[i].setReachable(status[i]);
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
                ++i;
            }
            this.updateMonitoredSlice();
            BEReplicationService.access$1302(BEReplicationService.this, replicas);
        }

        private void replicaUp(int index) throws IMTPException, ServiceException {
            BEReplicationService.this.myReplicas[index].setReachable(true);
            this.updateMonitoredSlice();
        }

        private void replicaDown(int index) throws IMTPException, ServiceException {
            BEReplicationService.this.myReplicas[index].setReachable(false);
            this.updateMonitoredSlice();
        }

        private void exitReplica() throws IMTPException {
            BEReplicationService.this.myContainer.shutDown();
        }

        private void bornAgent(AID name) {
            BackEndContainer.AgentImage img = BEReplicationService.this.myContainer.createAgentImage(name);
            BEReplicationService.this.myContainer.addAgentImage(name, img);
        }

        private void deadAgent(AID name) {
            BEReplicationService.this.myContainer.removeAgentImage(name);
        }

        public void dumpReplicas() {
            try {
                System.out.println("--- " + BEReplicationService.this.getLocalNode().getName() + "[" + BEReplicationService.this.myReplicaIndex + "] ---");
                System.out.println("--- Master replica is: " + BEReplicationService.this.masterSliceName + " ---");
                System.out.println("--- Replica list ---");
                int i = 0;
                while (i < BEReplicationService.this.myReplicas.length) {
                    BEReplicationSlice slice = BEReplicationService.this.myReplicas[i].getSlice();
                    System.out.println("----- " + slice.getNode().getName() + "[" + i + "] -----");
                    ++i;
                }
                System.out.println("--- End ---");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void nodeAdded(Node n) {
        }

        public void nodeRemoved(Node n) {
            try {
                int deadIndex = BEReplicationService.this.myMonitoredReplicaIndex;
                this.replicaDown(deadIndex);
                String sliceName = n.getName();
                LinkedList l = new LinkedList();
                l.add(BEReplicationService.this.getLocalNode().getName());
                l.add(n.getName());
                GenericCommand hCmd = new GenericCommand("5", "jade.core.replication.BEReplication", null);
                hCmd.addParam(new Integer(deadIndex));
                BEReplicationService.this.broadcastToReplicas(hCmd, l);
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }

        public void nodeUnreachable(Node n) {
        }

        public void nodeReachable(Node n) {
        }
    }

    private class IncomingCommandFilter
    extends Filter {
        private IncomingCommandFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Kill-Container")) {
                    this.handleKillMasterReplica(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
            return true;
        }

        private void handleKillMasterReplica(VerticalCommand cmd) throws IMTPException, ServiceException {
            if (BEReplicationService.this.masterSliceName.equals(BEReplicationService.this.getLocalNode().getName())) {
                GenericCommand hCmd = new GenericCommand("6", "jade.core.replication.BEReplication", null);
                BEReplicationService.this.broadcastToReplicas(hCmd, BEReplicationService.this.excludeMyself);
            }
        }

        public void setBlocking(boolean newState) {
        }

        public boolean isBlocking() {
            return false;
        }

        public void setSkipping(boolean newState) {
        }

        public boolean isSkipping() {
            return false;
        }
    }

    private class OutgoingCommandFilter
    extends Filter {
        private OutgoingCommandFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Inform-Created")) {
                    this.handleBornFEAgent(cmd);
                } else if (name.equals("Inform-Killed")) {
                    this.handleDeadFEAgent(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (NotFoundException nfe) {
                cmd.setReturnValue(nfe);
            }
            catch (NameClashException nce) {
                cmd.setReturnValue(nce);
            }
            catch (JADESecurityException ae) {
                cmd.setReturnValue(ae);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
            return true;
        }

        private void handleBornFEAgent(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            GenericCommand hCmd = new GenericCommand("7", "jade.core.replication.BEReplication", null);
            hCmd.addParam(agentID);
            BEReplicationService.this.broadcastToReplicas(hCmd, BEReplicationService.this.excludeMyself);
        }

        private void handleDeadFEAgent(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            GenericCommand hCmd = new GenericCommand("8", "jade.core.replication.BEReplication", null);
            hCmd.addParam(agentID);
            BEReplicationService.this.broadcastToReplicas(hCmd, BEReplicationService.this.excludeMyself);
        }

        public void setBlocking(boolean newState) {
        }

        public boolean isBlocking() {
            return false;
        }

        public void setSkipping(boolean newState) {
        }

        public boolean isSkipping() {
            return false;
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Become-Master")) {
                    this.handleBecomeMaster(cmd);
                } else if (name.equals("Is-Master")) {
                    cmd.setReturnValue(new Boolean(this.handleIsMaster(cmd)));
                } else if (name.equals("Get-Master-Name")) {
                    cmd.setReturnValue(this.handleGetMasterName(cmd));
                } else if (name.equals("Start-Monitor")) {
                    this.handleStartMonitor(cmd);
                } else if (name.equals("Stop-Monitor")) {
                    this.handleStopMonitor(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(new UnreachableException("Remote container is unreachable", imtpe));
            }
            catch (ServiceException se) {
                cmd.setReturnValue(new UnreachableException("A Service Exception occurred", se));
            }
        }

        private void handleBecomeMaster(VerticalCommand cmd) throws IMTPException, ServiceException {
            GenericCommand hCmd = new GenericCommand("2", "jade.core.replication.BEReplication", null);
            hCmd.addParam(BEReplicationService.this.getLocalNode().getName());
            BEReplicationService.this.broadcastToReplicas(hCmd, BEReplicationService.this.includeAll);
        }

        private boolean handleIsMaster(VerticalCommand cmd) throws IMTPException, ServiceException {
            return BEReplicationService.this.masterSliceName.equals(BEReplicationService.this.getLocalNode().getName());
        }

        private String handleGetMasterName(VerticalCommand cmd) throws IMTPException, ServiceException {
            return BEReplicationService.this.masterSliceName;
        }

        private void handleStartMonitor(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            long delay = (Long)params[0];
            BEReplicationService.this.startMonitor(delay);
        }

        private void handleStopMonitor(VerticalCommand cmd) {
            BEReplicationService.this.stopMonitor();
        }
    }
}

